
from platform import system as platform_name
from os import system
import ctypes

import string

driveTypes = [
    'DRIVE_UNKNOWN',
    'DRIVE_NO_ROOT_DIR',
    'DRIVE_REMOVABLE',
    'DRIVE_FIXED',
    'DRIVE_REMOTE',
    'DRIVE_CDROM',
    'DRIVE_RAMDISK'
]

def get_drive_list():
    """Return a list of all optical drives"""
    if platform_name() == "Windows":
        drives = []
        bitmask = ctypes.windll.kernel32.GetLogicalDrives()
        for letter in string.ascii_uppercase:
            if bitmask & 1:
                try:
                    typeIndex = ctypes.windll.kernel32.GetDriveTypeW("%s:\\" % letter)
                    if driveTypes[typeIndex] == "DRIVE_CDROM":
                        drives.append(letter + ":")
                except:
                    pass
            bitmask >>= 1

        return drives
    if platform_name == "Darwin":
        return ["tray"]

    return ["cdrom"]


def win_open(d):
    ctypes.windll.WINMM.mciSendStringW(f"open {d}: type CDAudio alias {d}_drive", None, 0, None)
    ctypes.windll.WINMM.mciSendStringW(f"set {d}_drive door open", None, 0, None)

def win_close(d):
    ctypes.windll.WINMM.mciSendStringW(f"open {d}: type CDAudio alias {d}_drive", None, 0, None)
    ctypes.windll.WINMM.mciSendStringW(f"set {d}_drive door closed", None, 0, None)

platforms_dictionary = {
    "Windows": {
        "open" : win_open,
        "close": win_close
    },
    "Darwin":  {
        "open" : lambda d: system("drutil tray open"),
        "close": lambda d: system("drutil tray closed")
    },
    "Linux":   {
        "open" : lambda d: system(f"eject {d}"),
        "close": lambda d: system(f"eject -t {d}")
    },
}


def open_tray(drive):
    platforms_dictionary[platform_name()]["open"](drive)

def close_tray(drive):
    platforms_dictionary[platform_name()]["close"](drive)
